<?php

/* PRINCIPE du plugin :
	* Dans le constructeur du plugin (appelé par PluXml juste avant de charger la liste des articles, avant le getInstance et donc avant le initCache) :
			Je modifie le $this->aConf['racine_articles'], et le $this->aConf['racine_commentaires'] pour les faire pointer sur un dossier vide. Comme ça initCache ne fait pas son job.
			Ensuite je charge $aFiles de plxGlob_arts et plxGlob_coms depuis un fichier
	
	 * Hook plxMotorConstruct :
			Je remet en place les variables aConf['racine_articles'] et aConf['racine_commentaires'].
*/

/**
 * Plugin  plxCache
 *
 * @package PLX
 * @version 1.0
 * @date	05/12/2011
 * @author	jfphilippe, Amaury G.
 * */
 
 define('FiART', PLX_PLUGINS.'/plxCacheSansTheme/cache_art.ser');
 define('FiCOM', PLX_PLUGINS.'/plxCacheSansTheme/cache_com.ser');
 define('FiCAT', PLX_PLUGINS.'/plxCacheSansTheme/cache_cat.ser');

 class plxCacheSansTheme extends plxPlugin {

	private $rac_art = null;
	private $rac_com = null;
	private $cat_file = null;

	protected $plxMotor;

	
    /**
     * Constructeur de la classe
     * @param string $default_lang langue par defaut.
     * @author	jfphilippe, Amaury G.
     * */
    public function __construct($default_lang, &$plxMotor) {
        # Appel du constructeur de la classe plxPlugin (obligatoire)
        parent::__construct($default_lang);
		
		$this->addHook('plxMotorConstruct', 'plxMotorConstruct');
		
		# Hook de mise à jour :
		$this->addHook('plxAdminEditArticleXml', 'resetCache_art');
       		$this->addHook('plxMotorAddCommentaireXml', 'resetCache_com');
	        $this->addHook('plxAdminEditConfiguration', 'resetCache');
	        $this->addHook('plxAdminEditCategoriesXml', 'resetCache_art');		

		$this->plxMotor = &$plxMotor;
		
		# Sauvegarde de la configuration :
		$this->rac_art = $this->plxMotor->aConf['racine_articles'];
		$this->rac_com = $this->plxMotor->aConf['racine_commentaires'];
		$this->cat_file = $this->plxMotor->aConf['categories'];
		
		# Génère les fichiers (uniquement si la page 1 a été mise en cache)
		if($this->plxMotor->get=='' or preg_match('/^(page|article|categorie)/', $this->plxMotor->get)) {
			# Permet d'éviter que initCache fasse son job : empêche PluXml de parser tous les articles et les coms en donnant un nom de fichier inconnu
			if(file_exists(FiART)) {
				$this->plxMotor->aConf['racine_articles'] = 1; # on met des chiffres différents plutôt que null car les singletons sont identifiés par le nom du fichier
				$this->plxMotor->aConf['categories'] = 1;
			}
			if(file_exists(FiCOM))
				$this->plxMotor->aConf['racine_commentaires'] = 2;
		}
    }
	
	# Hook appelé juste après initCache de PluXml
	public function plxMotorConstruct() {
	
		# On charge la liste des articles depuis le cache
		if($this->plxMotor->aConf['racine_articles'] == 1) {
                		$this->plxMotor->plxGlob_arts->aFiles = unserialize(file_get_contents(FiART));
				$this->plxMotor->aConf['racine_articles'] = $this->rac_art;

				# la lecture des categories utilise la liste des articles.
        			# la structure est également cachée.
                		$this->plxMotor->aConf['categories'] = $this->cat_file;
                		$this->plxMotor->aCats = unserialize(file_get_contents(FiCAT));
		}
		# Génération du cache
		else  {
				# Les articles
				$hdle = fopen(FiART, 'w');
				fwrite($hdle, serialize($this->plxMotor->plxGlob_arts->aFiles));
				fclose($hdle);

				# Les catégories
                		$hdle = fopen(FiCAT, 'w');
                		fwrite($hdle, serialize($this->plxMotor->aCats));
				fclose($hdle);
		}
		
		# On charge la liste des commentaires depuis le cache
		if($this->plxMotor->aConf['racine_commentaires'] == 2) {
                		$this->plxMotor->plxGlob_coms->aFiles = unserialize(file_get_contents(FiCOM));
				$this->plxMotor->aConf['racine_commentaires'] = $this->rac_com;
		}
		# Génération du cache
		else  {
				$hdle = fopen(FiCOM, 'w');
				fwrite($hdle, serialize($this->plxMotor->plxGlob_coms->aFiles));
				fclose($hdle);
		}
	}
	
	//------------------------------------------------------------------------------------------------------------------------------------
	
	# Fonctions de réinitialisation du cache :
	public function resetCache_art() {
		unlink(FiART);
		unlink(FiCAT);
	}
	
	public function resetCache_com() {
		unlink(FiCOM);
	}
	
	public function resetCache () {
		resetCache_commentaires();
		resetCache_article();
	}
}
